<?php
/*
Plugin Name: MM Redirect on Login
Description: Redirect to previously visited page on login to MemberMouse
Author: Public Domain
Author URI: http://nowhere.loopback.edu/
Plugin URI: http://nowhere.loopback.edu/
Version: 1.0.4
*/

$_mmrl_redirectCookie = "mmrl_redirect_id";
$_mmrl_redirectPeriod = 3600;
$_mmrl_redirectUnprotected = FALSE;
$_mmrl_otherRedirectorIDs = array();
$_mmrl_ignoreRedirection = array();


function mmrl_redirector() {
	global $_mmrl_redirectCookie, $_mmrl_redirectPeriod, $_mmrl_redirectUnprotected;
	global $_mmrl_otherRedirectorIDs, $_mmrl_ignoreRedirection;
	if ( is_singular() && !is_attachment() ) {
		$currentPID = get_the_id();
		if ( !is_user_logged_in() && $_mmrl_redirectUnprotected == TRUE && !in_array($currentPID, $_mmrl_ignoreRedirection) ) {
			$corePages = mmrl_getCorePageIDs();
			if(!empty($corePages)) {
				if ( !in_array($currentPID, $corePages) ) {
					setcookie($_mmrl_redirectCookie, $currentPID, time() + $_mmrl_redirectPeriod, "/");
				}
			}
		}
		if ( is_user_logged_in() ) {
			$memberHomePages = mmrl_getCorePageIDs("member");
			if ( ( in_array($currentPID, $memberHomePages) || in_array($currentPID, $_mmrl_otherRedirectorIDs)) && isset($_COOKIE[$_mmrl_redirectCookie]) ) {
				$cookieValue = $_COOKIE[$_mmrl_redirectCookie];
				if ( is_numeric($cookieValue) && $cookieValue > 0 && $cookieValue == round($cookieValue) ) {
					$redirectURL = get_permalink($_COOKIE[$_mmrl_redirectCookie]);
					setcookie($_mmrl_redirectCookie, null, time() - 3600, "/");
					wp_safe_redirect($redirectURL, 307);
					exit();
				}
			}
		}
	}
}
add_action("template_redirect", "mmrl_redirector");

function mmrl_setProtectedRedirectCookie( $data ) {
	global $_mmrl_redirectCookie, $_mmrl_redirectPeriod;
	global $_mmrl_ignoreRedirection;
	if ( !is_user_logged_in() && is_singular() && !is_attachment() ) {
		$currentPID = get_the_id();
		if ( !in_array($currentPID, $_mmrl_ignoreRedirection) ) {
			setcookie($_mmrl_redirectCookie, $currentPID, time() + $_mmrl_redirectPeriod, "/");
		}
		
	}
	return false;
}
add_filter("mm_bypass_content_protection", "mmrl_setProtectedRedirectCookie");

function mmrl_getCorePageIDs($type = "all") {
	global $wpdb;
	if ( $type == "member" ) {
		$sql = "SELECT page_id FROM mm_core_pages WHERE core_page_type_id = 1 AND page_id IS NOT NULL";
	} 
	if ( $type == "all" ) {
		$sql = "SELECT page_id FROM mm_core_pages WHERE page_id IS NOT NULL";
	}
	$result = $wpdb->get_results( $sql );
	$corePageArray = array();
	foreach ($result as $row) {
		$corePageArray[] = $row->page_id;
	}
	return $corePageArray;
}
?>